<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2023-01-24 21:04
 */
interface ProductionoutmanyoutproductsDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Productionoutmanyoutproducts 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param productionoutmanyoutproduct primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Productionoutmanyoutproducts productionoutmanyoutproduct
 	 */
	public function insert($productionoutmanyoutproduct);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Productionoutmanyoutproducts productionoutmanyoutproduct
 	 */
	public function update($productionoutmanyoutproduct);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByProductionoutmanyid($value);

	public function queryByProductid($value);

	public function queryBySizeid($value);

	public function queryByColorid($value);

	public function queryByProunitid($value);

	public function queryByQuantity($value);

	public function queryByUnitprice($value);

	public function queryByCost($value);


	public function deleteByProductionoutmanyid($value);

	public function deleteByProductid($value);

	public function deleteBySizeid($value);

	public function deleteByColorid($value);

	public function deleteByProunitid($value);

	public function deleteByQuantity($value);

	public function deleteByUnitprice($value);

	public function deleteByCost($value);


}
?>